/*
 *    Questo codice ha lo scopo di gestire una scheda Arduino UNO per il monitoraggio della qualità dell'aria durante l'utilizzo di una stampante 3D
 *    
 *    Creato: Marzo 2019
 *    da Sos3DPrinting (sos3dprinting.com)
 *    
 *    Tutti i diritti sono riservati
 *    E' consentito l'utilizzo personale
 *    E' vietata la vendita e la divulgazione del codice
 *    La modifica è consentita citando il file originale
 */

 //Impostazioni
int pm25Limite    = 120;  //Valore limite per il PM2.5, superata la soglia suona l'allarme                          Valore consigliato: 100
int vocsLimite    = 250;  //Valore limite per il VOCs, superata la soglia suona l'allarme                           Valore consigliato: 250
int delayBuzzer   = 250;  //Tempo in ms (millisecondi) che il buzzer (allarme) sta acceso/spento durante l'allarme  Valore consigliato: 250
int tiscaldamento = 2000; //Tempo in ms (millisecondi) per il riscaldamento dei sensori                             Valore consigliato: 2000

 /*
  * !!!!!SE NON SAI COSA STAI FACENDO NON MODIFICARE IL CODICE QUI SOTTO!!!!!!!
  */
 
 //Variabili

int dustPin=A1;
float dustVal=0; 
int ledPower=12;
int delayTime=280;
int delayTime2=40;
float offTime=9680;

int pm25 = 0;
int vocs = 0;
int buzzer = 4;
int vocspin = A3;

void setup() {
  Serial.begin(9600);
  Serial.println("AVVIAMENTO...");
  pinMode(ledPower, OUTPUT);
  pinMode(dustPin, INPUT);
  pinMode(buzzer, OUTPUT);
  digitalWrite(buzzer, HIGH);
  delay(250);
  digitalWrite(buzzer, LOW);
  delay(250);
  digitalWrite(buzzer, HIGH);
  delay(250);
  digitalWrite(buzzer, LOW);
  Serial.println("AVVIATO");
  delay(500);
  Serial.println("\nRISCALDAMENTO...");
  delay(2000);
  Serial.println("RISCALDATO");
  Serial.println("SARANNO COMUNQUE NECESSARI ALTRI 5 MINUTI PRIMA DI OTTENERE VALORI AFFIDABILI PER I VOCs1n");
}

void loop() {
  digitalWrite(ledPower,LOW); 
  delayMicroseconds(delayTime);
  dustVal=analogRead(dustPin); 
  delayMicroseconds(delayTime2);
  digitalWrite(ledPower,HIGH); 
  delayMicroseconds(offTime);

  Serial.print("PM2.5:  ");
  if (dustVal>36.455)
  Serial.println((float(dustVal/1024)-0.0356)*120000*0.035);

  pm25 = (float(dustVal/1024)-0.0356)*120000*0.035;
  vocs = analogRead(vocspin);

  Serial.print("VOCs: ");
  Serial.println(vocs);

  if (pm25 > pm25Limite) {
    allarme();
    Serial.println("ALLARME PM2.5");
  }

  if (vocs > vocsLimite) {
    allarme();
    Serial.println("ALLARME VOCs");
  }

  delay(1000);
}

void allarme() {
  digitalWrite(buzzer, HIGH);
  delay(delayBuzzer);
  digitalWrite(buzzer, LOW);
  delay(delayBuzzer);
  digitalWrite(buzzer, HIGH);
  delay(delayBuzzer);
  digitalWrite(buzzer, LOW);
  delay(delayBuzzer);
  digitalWrite(buzzer, HIGH);
  delay(delayBuzzer);
  digitalWrite(buzzer, LOW);
}

